/*
* Creation date : Tues Mar 26 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* RC4 functions. 
*
* \version CE2_RC4.c#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_RC4.h"
#include "LLF_RC4.h"

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/
/************************ Private function prototype **********/
/************************ Private Functions *******************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  CE2_RC4
*
*  @param Key_ptr [in] - A pointer to the user's key buffer.
*  @param KeySizeInBytes [in] - The size of the KEY in bytes.
*  @param DataIn_ptr [in] - The pointer to the buffer of the input data to the RC4. 
*                   The pointer's value does not need to be word-aligned.
*  @param DataInSize [in] - The size of the input data.
*  @param DataOut_ptr [in/out] The pointer to the buffer of the output data from the RC4.
*                The pointer's value does not need to be word-aligned. 
*                The size of this buffer must be the same as the DataIn buffer.  
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_RC4_INVALID_USER_CONTEXT_POINTER_ERROR,
*   - CE2_RC4_USER_CONTEXT_CORRUPTED_ERROR
*
* \brief \b 
* Description:
*  This function provides a RC4 function for processing data.
*
*  The function allocates an internal RC4 Context, and initializes the RC4 Context with the
*  cryptographic attributes that are needed for the RC4 cryptographic operation. Next the
*  function loads the engine with the initializing values, and then processes the data,
*  returning the processed data in the output buffer. Finally, the function frees the
*  internally allocated context.
*
*  \b 
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_RC4 
*     for AES with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_RC4  (DxUint8_t 				      *Key_ptr, 
                               DxUint32_t 				   KeySizeInBytes,
                               DxUint8_t                    *DataIn_ptr,                                  
                               DxUint32_t                    DataInSize,
                               DxUint8_t                    *DataOut_ptr)
{
  if (Key_ptr == DX_NULL)
    return CE2_RC4_KEY_PTR_ERROR;

  if (DataIn_ptr == DX_NULL)
    return CE2_RC4_DATA_IN_PTR_ERROR;

  if (DataOut_ptr == DX_NULL)
    return CE2_RC4_DATA_OUT_PTR_ERROR;

  return LLF_RC4(Key_ptr, KeySizeInBytes, DataIn_ptr, DataInSize, DataOut_ptr);
}
